#include <iostream>
#include <algorithm>
#include <vector>

using namespace std;
#define ll long long

int main()
{
	ios::sync_with_stdio(false);

	int test_count; cin >> test_count;
	for (size_t test_no	= 0; test_no < test_count; test_no++)
	{
		int n, k; cin >> n >> k;
		vector<ll> prefix_sums(n);
		cin >> prefix_sums[0];
		for (size_t i = 1; i < n; i++)
		{
			ll element; cin >> element;
			prefix_sums[i] = prefix_sums[i - 1] + element;
		}

		bool can_win = false;
		// Try all possibe moves for the first player
		for (size_t i = 0; i < n && !can_win; i++)
		{
			ll score_A = prefix_sums[i];
			if (score_A > k)
				break;
			// The player B should always pick at least one card at this point (no need to check 0)
			// Find the optimal choice for player B - player B should pick the smallest i such that
			//  k + score_A >= prefix_sums[i] > 2*score_A
			auto it = upper_bound(prefix_sums.begin(), prefix_sums.end(), 2 * score_A);
			if (it == prefix_sums.end()) // Player B has no way of reaching more than player A, so player A wins
				can_win = true;
			else
			{
				ll scoreB = *it - score_A;
				if (scoreB > k) // Player B can reach a higher score than player A but it is greater than k, so A wins
					can_win = true;
			}
		}
		if (can_win)
			cout << "da\n";
		else
			cout << "ne\n";
	}
	return 0;
}